

    ' ========== Life simulator by Alexandre Lomuto ==========
    nomainwin
    GameVersion$ = "1.0" : UNIT = 100 : sizeEDITOR = 1 : Dx = 5000 : dayW = 0 : DxMAX = 135000
    WindowWidth = 807 : WindowHeight = 630 : mapWidth = 800 : mapHeight = 580
    UpperLeftX = int((DisplayWidth - WindowWidth) / 4) : UpperLeftX2 = UpperLeftX
    UpperLeftY = int((DisplayHeight - WindowHeight) / 2)
    dim p(800, 580), CoorX(10000000), CoorY(10000000), valU(10000000), LIFE(10000000), natality(10000000), genetic(10000000), VittesseU(10000000)
    PLANTCODE = 1000001 : WATERCODE = 1000002 : ROCKCODE = 1000003 : GENETICHERBIVORE = 1 : GENETICCARNIVORE = 2


    ' ========== INTERFACE ==========
    graphicbox #ini.info, 0, 0, 801, 22
    graphicbox #ini.main, 0, 22, 801, 580
    button #ini.help, "?", [about], UL, 2, 1, 20, 20
    button #ini.log, "Log", [log], UL, 90, 1, 30, 20
    button #ini.pause, "Days", [pause], UL, 119, 1, 35, 20
    button #ini.save, "Save", [save], UL, 22, 1, 35, 20
    button #ini.load, "Load", [load], UL, 56, 1, 35, 20
    open "Life Simulator " + GameVersion$ for window_nf as #ini
    #ini, "trapclose [quit]"
    print #ini.main, "down; fill 240 190 150"
    print #ini.info, "down; fill white; font Cascadia_Code 8; color black; backcolor white"
    print #ini.help, "!disable" : print #ini.log, "!disable" : print #ini.pause, "!disable"
    print #ini.save, "!disable" : print #ini.load, "!disable"
    gosub [GenerateWorld]


    ' ========== GNRATION PLANTES ==========
    plantCount = 0
    for attempt = 1 to 50000
        scan : plantX = int(rnd(1) * 796 + 2) : plantY = int(rnd(1) * 576 + 2)
        if p(plantX, plantY) = 0 then
            p(plantX, plantY) = PLANTCODE : plantCount = plantCount + 1
            print #ini.main, "size 2; color 0 140 0; set "; plantX; " "; plantY; "; color 0 100 0; set "; plantX; " "; plantY + 2
            if plantCount >= 30000 then exit for
        end if
    next attempt


    ' ========== GNRATION ANIMAUX ==========
    Ngenetic1 = 0 : Ngenetic2 = 0
    for n = 1 to UNIT
        scan : validPos = 0
        for attempt = 1 to 100
            testX = int(rnd(1) * 796 + 2) : testY = int(rnd(1) * 576 + 2)
            if p(testX, testY) = 0 or p(testX, testY) = PLANTCODE then CoorX(n) = testX : CoorY(n) = testY : validPos = 1 : exit for
        next attempt
        if validPos = 0 then goto [skipAnimal]
        randGen = int(rnd(1) * 10 + 1)
        if randGen <= 9 then genetic(n) = GENETICHERBIVORE : Ngenetic1 = Ngenetic1 + 1 : LIFE(n) = 1000 : valU(n) = 1 : VittesseU(n) = 0
        if randGen > 9 then genetic(n) = GENETICCARNIVORE : Ngenetic2 = Ngenetic2 + 1 : LIFE(n) = 4000 : valU(n) = n : VittesseU(n) = 1
        [skipAnimal]
    next n

    gosub [InitInterface]
    print #ini.help, "!enable" : print #ini.log, "!enable" : print #ini.pause, "!enable" : print #ini.save, "!enable" : print #ini.load, "!enable"

    ' Commandes prcalcules
    cmdClear$ = "color 240 190 150; set " : cmdWhite$ = "color 255 255 255; set "
    cmdBlue$ = "color 0 0 255; set "      : cmdPlantD$ = "color 0 140 0; set "
    cmdPlantL$ = "color 0 100 0; set "    : cmdWater$ = "color 150 100 230; set "

    ' ========== BOUCLE PRINCIPALE ==========
    [boucle]
    timer 0 : scan : day = day + 1 : dayW = dayW + 1
    if dayW > 135000 then
        DxMAX = DxMAX + 135000 : dayW = 0 : if logACTIVATION = 1 then goto [refreshLOG]
    end if
    if logACTIVATION = 1 and dayW mod 4 = 1 then xPos = int(1 + dayW / 200) + 70 : #wg "size 1; color white; set "; xPos; " "; (570 - Ngenetic1 / 3); "; color blue; set "; xPos; " "; (570 - Ngenetic2 / 3); "; color yellow; set "; xPos; " 570"
    if day mod 10 = 0 then print #ini.info, "discard; place 165 13 ;\"; day; "  |  Herbivors : "; Ngenetic1; " ["; death; " dead]  |  Carnivors : "; Ngenetic2; "   "
    print #ini.main, "discard; size 2"

    ' Rgnration plantes
    for r = 1 to 5
        regenX = int(rnd(1) * 796 + 2) : regenY = int(rnd(1) * 576 + 2)
        if p(regenX, regenY) = 0 and p(regenX, regenY + 1) = 0 and p(regenX, regenY + 2) = 0 then
            p(regenX, regenY) = PLANTCODE : p(regenX, regenY + 1) = PLANTCODE : p(regenX, regenY + 2) = PLANTCODE
            print #ini.main, cmdPlantD$; regenX; " "; regenY; "; "; cmdPlantL$; regenX; " "; regenY + 2
        end if
    next r

    ' Mise  jour entits
    for x = 1 to UNIT
        vU = valU(x)
        if vU = 0 then goto [next]
        lifeX = LIFE(x)
        if lifeX <= 0 then goto [next]
        vitX = VittesseU(x) : lifeX = lifeX - (1 + vitX) : LIFE(x) = lifeX
        cX = CoorX(x) : cY = CoorY(x) : genX = genetic(x)
        if lifeX <= 0 then
            valU(x) = 0
            if genX = GENETICHERBIVORE then Ngenetic1 = Ngenetic1 - 1 else Ngenetic2 = Ngenetic2 - 1
            print #ini.main, cmdClear$; cX; " "; cY
            p(cX, cY) = 0 : gosub [DrawEnv] : goto [next]
        end if
        print #ini.main, cmdClear$; cX; " "; cY
        gosub [DrawEnv] : p(cX, cY) = 0
        Mooving = int(rnd(1) * 9 + 1) : speed = 1 + vitX : gosub [Move]
        cX = CoorX(x) : cY = CoorY(x)
        if genX = GENETICHERBIVORE then gosub [Herbivore] else gosub [Carnivore]
        [next]
    next x

    ' Repopulation
    if Ngenetic1 <= 2 then
        newHERB = newHERB + 1 : if newHERB > 1000 then gosub [SpawnHerb] : newHERB = 0
    end if
    if Ngenetic2 <= 8 then
        newCARN = newCARN + 1 : if newCARN > 1500 then gosub [SpawnCarn] : newCARN = 0
    end if
    timer 1, [boucle] : wait

    ' ========== ROUTINES ==========
    [InitInterface]
    print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "color black; place 525 13 ;\"; "Editor : "
    print #ini.info, "place 720 13 ;\"; "Size :"
    print #ini.info, "size 15; color black; set 590 10; set 610 10; set 630 10; set 650 10; set 670 10; set 690 10"
    print #ini.info, "size 13; color 240 190 150; set 590 10; color 150 100 230; set 610 10; color 0 180 0; set 630 10; color darkgray; set 650 10; color 240 190 150; set 670 10; set 690 10"
    print #ini.info, "size 8; color black; set 765 10; size 6; color red; set 765 10; size 14; color black; set 785 10; size 12; color white; set 785 10"
    print #ini.info, "size 4; color white; set 670 10; color blue; set 690 10; font Cascadia_Code 8; color black; backcolor white; when leftButtonDown [select]; flush"
    print #ini.main, "when leftButtonDown [position]; when leftButtonMove [terrain]; flush"
    return

    [DrawEnv]
    pVal = p(cX, cY)
    if pVal = PLANTCODE or p(cX, cY - 1) = PLANTCODE or p(cX, cY + 1) = PLANTCODE or p(cX - 1, cY) = PLANTCODE or p(cX + 1, cY) = PLANTCODE then
        print #ini.main, "size 2; "; cmdPlantD$; cX; " "; cY; "; "; cmdPlantL$; cX; " "; cY + 2
        return
    end if
    if pVal = WATERCODE or p(cX, cY - 1) = WATERCODE or p(cX, cY + 1) = WATERCODE then print #ini.main, "size 2; "; cmdWater$; cX; " "; cY; " set "; cX; " "; cY + 2
    return

    [Move]
    select case Mooving
    case 1
        newX = cX + speed
        if newX <= 798 and p(newX, cY) < WATERCODE then
            CoorX(x) = newX
        else
            if newX >= 798 then CoorX(x) = 2
        end if
    case 2
        newX = cX + speed : newY = cY + speed
        if newY <= 578 and newX <= 798 and p(newX, cY) < WATERCODE and p(cX, newY) < WATERCODE then
            CoorX(x) = newX : CoorY(x) = newY
        else
            if newX >= 798 then CoorX(x) = 2
            if newY >= 578 then CoorY(x) = 2
        end if
    case 3
        newY = cY + speed
        if newY <= 578 and p(cX, newY) < WATERCODE then
            CoorY(x) = newY
        else
            if newY >= 578 then CoorY(x) = 2
        end if
    case 4
        newX = cX - speed : newY = cY + speed
        if newY <= 578 and newX >= 2 and p(newX, cY) < WATERCODE and p(cX, newY) < WATERCODE then
            CoorX(x) = newX : CoorY(x) = newY
        else
            if newX <= 2 then CoorX(x) = 798
            if newY >= 578 then CoorY(x) = 2
        end if
    case 5
        newX = cX - speed
        if newX >= 2 and p(newX, cY) < WATERCODE then
            CoorX(x) = newX
        else
            if newX <= 2 then CoorX(x) = 798
        end if
    case 6
        newX = cX - speed : newY = cY - speed
        if newY >= 2 and newX >= 2 and p(newX, cY) < WATERCODE and p(cX, newY) < WATERCODE then
            CoorX(x) = newX : CoorY(x) = newY
        else
            if newX <= 2 then CoorX(x) = 798
            if newY <= 2 then CoorY(x) = 578
        end if
    case 7
        newY = cY - speed
        if newY >= 2 and p(cX, newY) < WATERCODE then
            CoorY(x) = newY
        else
            if newY <= 2 then CoorY(x) = 578
        end if
    case 8
        newX = cX + speed : newY = cY - speed
        if newY >= 2 and newX <= 798 and p(newX, cY) < WATERCODE and p(cX, newY) < WATERCODE then
            CoorX(x) = newX : CoorY(x) = newY
        else
            if newX >= 798 then CoorX(x) = 2
            if newY <= 2 then CoorY(x) = 578
        end if
    end select
    return

    [Herbivore]
    hasNeighbor = 0 : natX = natality(x)
    if valU(p(cX - 1, cY - 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX, cY - 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX + 1, cY - 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX - 1, cY)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX + 1, cY)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX - 1, cY + 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX, cY + 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 0 and valU(p(cX + 1, cY + 1)) = 1 then hasNeighbor = 1
    if hasNeighbor = 1 and natX > 20 then gosub [ReprodH]
    pCur = p(cX, cY)
    if pCur = PLANTCODE then
        if lifeX < 5000 then LIFE(x) = lifeX + 50 : natality(x) = natX + 1 : p(cX, cY) = x : print #ini.main, cmdWhite$; cX; " "; cY
        if lifeX >= 5000 then print #ini.main, cmdPlantD$; cX; " "; cY : p(cX, cY) = x
    else
        if pCur < WATERCODE then print #ini.main, cmdWhite$; cX; " "; cY : p(cX, cY) = x
    end if
    if natality(x) >= 100 and LIFE(x) > 800 then gosub [ReprodH]
    return

    [Carnivore]
    print #ini.main, cmdBlue$; cX; " "; cY
    killed = 0
    if valU(p(cX + 1, cY)) = 1 then killed = p(cX + 1, cY) : goto [kill]
    if valU(p(cX + 1, cY - 1)) = 1 then killed = p(cX + 1, cY - 1) : goto [kill]
    if valU(p(cX - 1, cY)) = 1 then killed = p(cX - 1, cY) : goto [kill]
    if valU(p(cX - 1, cY - 1)) = 1 then killed = p(cX - 1, cY - 1) : goto [kill]
    if valU(p(cX, cY + 1)) = 1 then killed = p(cX, cY + 1) : goto [kill]
    if valU(p(cX + 1, cY + 1)) = 1 then killed = p(cX + 1, cY + 1) : goto [kill]
    if valU(p(cX, cY - 1)) = 1 then killed = p(cX, cY - 1) : goto [kill]
    if valU(p(cX - 1, cY + 1)) = 1 then killed = p(cX - 1, cY + 1) : goto [kill]
    goto [noKill]
    [kill]
    valU(killed) = 0 : Ngenetic1 = Ngenetic1 - 1 : p(cX, cY) = 0 : LIFE(x) = LIFE(x) + LIFE(killed) + 1 : natality(x) = natality(x) + 1 : death = death + 1 : LIFE(killed) = 0
    [noKill]
    if natality(x) >= 2 then gosub [ReprodC]
    p(cX, cY) = x
    return

    [ReprodH]
    LIFE(x) = int(LIFE(x) / 4) + 1 : natality(x) = 0 : UNIT = UNIT + 1 : valU(UNIT) = 1 : CoorX(UNIT) = CoorX(x) : CoorY(UNIT) = CoorY(x) : LIFE(UNIT) = 1000 : Ngenetic1 = Ngenetic1 + 1 : genetic(UNIT) = GENETICHERBIVORE : VittesseU(UNIT) = 0 : return

    [ReprodC]
    LIFE(x) = int(LIFE(x) / 2) + 1 : natality(x) = 0 : UNIT = UNIT + 1 : valU(UNIT) = UNIT : CoorX(UNIT) = CoorX(x) : CoorY(UNIT) = CoorY(x) : LIFE(UNIT) = 4000 : Ngenetic2 = Ngenetic2 + 1 : genetic(UNIT) = GENETICCARNIVORE : VittesseU(UNIT) = 1 : return

    [SpawnHerb]
    for attempt = 1 to 100
        testX = int(rnd(1) * 796 + 2) : testY = int(rnd(1) * 576 + 2)
        if p(testX, testY) = 0 or p(testX, testY) = PLANTCODE then
            UNIT = UNIT + 1 : valU(UNIT) = 1 : CoorX(UNIT) = testX : CoorY(UNIT) = testY
            LIFE(UNIT) = 1000 : genetic(UNIT) = GENETICHERBIVORE
            Ngenetic1 = Ngenetic1 + 1 : VittesseU(UNIT) = 0 : exit for
        end if
    next attempt
    return

    [SpawnCarn]
    for attempt = 1 to 100
        testX = int(rnd(1) * 796 + 2) : testY = int(rnd(1) * 576 + 2)
        if p(testX, testY) = 0 or p(testX, testY) = PLANTCODE then
            UNIT = UNIT + 1 : valU(UNIT) = UNIT : CoorX(UNIT) = testX : CoorY(UNIT) = testY
            LIFE(UNIT) = 4000 : genetic(UNIT) = GENETICCARNIVORE
            Ngenetic2 = Ngenetic2 + 1 : VittesseU(UNIT) = 1 : exit for
        end if
    next attempt
    return


    ' ========== SAUVEGARDE/CHARGEMENT ==========
    [save]
    pause = 1 : print #ini.pause, "Play" : timer 0
    print #ini.info, "place 310 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "place 310 13; color black; backcolor white ;\"; "Saving in progress..."
    filedialog "Sauvegarder la partie", "*.lsv", saveFile$
    if saveFile$ = "" then goto [boucle]
    if instr(saveFile$, ".lsv") = 0 then saveFile$ = saveFile$ + ".lsv"
    open saveFile$ for output as #save

    ' En-tte et paramtres globaux
    print #save, "LIFESIM_SAVE_V1"
    print #save, day
    print #save, UNIT
    print #save, Ngenetic1
    print #save, Ngenetic2
    print #save, death

    ' Sauvegarde de la carte (format compress - seulement les cases non-vides)
    print #save, "MAP_START"
    mapItemCount = 0
    for yy = 0 to 580
        scan
        for xx = 0 to 800
            pVal = p(xx, yy)
            if pVal <> 0 then
                print #save, xx
                print #save, yy
                print #save, pVal
                mapItemCount = mapItemCount + 1
            end if
        next xx
    next yy
    print #save, "MAP_END"

    ' Sauvegarde des entits vivantes
    print #save, "ENTITIES_START"
    entityCount = 0
    for x = 1 to UNIT
        scan
        if valU(x) > 0 and LIFE(x) > 0 then
            print #save, x
            print #save, CoorX(x)
            print #save, CoorY(x)
            print #save, valU(x)
            print #save, LIFE(x)
            print #save, natality(x)
            print #save, genetic(x)
            print #save, VittesseU(x)
            entityCount = entityCount + 1
        end if
    next x
    print #save, "ENTITIES_END"
    close #save
    notice "Backup complete !" + chr$(13) + "File : " + saveFile$ + chr$(13) + chr$(13) + "Map : " + str$(mapItemCount) + " elements" + chr$(13) + "Entities : " + str$(entityCount) + " creatures"
    goto [boucle]

    [load]
    pause = 1 : print #ini.pause, "Play" : timer 0
    print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "place 300 13; color black; backcolor white ;\"; "Loading..."
    filedialog "Charger une partie", "*.lsv", loadFile$
    if loadFile$ = "" then goto [boucle]
    open loadFile$ for input as #load

    ' Vrification de la version
    input #load, versionCheck$
    if versionCheck$ <> "LIFESIM_SAVE_V1" then notice "Invalid backup file or incompatible version!" : close #load : goto [boucle]

    ' Chargement des paramtres globaux
    input #load, day
    input #load, UNIT
    input #load, Ngenetic1
    input #load, Ngenetic2
    input #load, death

    ' Rinitialisation complte de la carte
    print #ini.main, "cls; down; fill 240 190 150"
    for yy = 0 to 580
        for xx = 0 to 800
            p(xx, yy) = 0
        next xx
    next yy

    ' Rinitialisation des entits
    for x = 1 to 10000
        valU(x) = 0 : LIFE(x) = 0 : natality(x) = 0
        CoorX(x) = 0 : CoorY(x) = 0 : genetic(x) = 0 : VittesseU(x) = 0
    next x

    ' Chargement de la carte
    input #load, marker$
    if marker$ = "MAP_START" then
        print #ini.main, "size 2"
        while EOF(#load) = 0
            scan
            input #load, dataValue$
            if dataValue$ = "MAP_END" then exit while
            xx = val(dataValue$)
            input #load, yy
            input #load, pVal
            p(xx, yy) = pVal
            ' Affichage selon le type
            if pVal = WATERCODE then print #ini.main, "color 150 100 230; set "; xx; " "; yy
            if pVal = ROCKCODE then grayShade = int(90 + rnd(1) * 30) : print #ini.main, "color "; grayShade; " "; grayShade + 10; " "; grayShade + 10; "; set "; xx; " "; yy
            if pVal = PLANTCODE then print #ini.main, "color 0 140 0; set "; xx; " "; yy; "; color 0 100 0; set "; xx; " "; yy + 2
        wend
    end if

    ' Chargement des entits
    input #load, marker$
    if marker$ = "ENTITIES_START" then
        while EOF(#load) = 0
            scan
            input #load, dataValue$
            if dataValue$ = "ENTITIES_END" then exit while
            x = val(dataValue$)
            input #load, CoorX(x)
            input #load, CoorY(x)
            input #load, valU(x)
            input #load, LIFE(x)
            input #load, natality(x)
            input #load, genetic(x)
            input #load, VittesseU(x)
        wend
    end if
    close #load

    ' Raffichage des entits sur la carte
    print #ini.main, "size 2"
    for x = 1 to UNIT
        if valU(x) > 0 and LIFE(x) > 0 then
            if genetic(x) = GENETICHERBIVORE then
                print #ini.main, "color 255 255 255; set "; CoorX(x); " "; CoorY(x)
            else
                print #ini.main, "color 0 0 255; set "; CoorX(x); " "; CoorY(x)
            end if
        end if
    next x
    goto [boucle]


    ' ========== VNEMENTS ==========
    [select]
    mX = MouseX : mY = MouseY
    print #ini.info, "size 2; color white; set 683 3; set 663 3; set 643 3; set 623 3; set 603 3; set 582 3"
    if mX > 580 and mX < 598 then competence = 1 : pause = 1 : print #ini.pause, "Play" : XxX = 582 : YyY = 3
    if mX > 602 and mX < 617 then competence = 2 : pause = 1 : print #ini.pause, "Play" : XxX = 603 : YyY = 3
    if mX > 623 and mX < 637 then competence = 3 : pause = 1 : print #ini.pause, "Play" : XxX = 623 : YyY = 3
    if mX > 644 and mX < 657 then competence = 4 : pause = 1 : print #ini.pause, "Play" : XxX = 643 : YyY = 3
    if mX > 662 and mX < 678 then competence = 5 : pause = 1 : print #ini.pause, "Play" : XxX = 663 : YyY = 3
    if mX > 682 and mX < 698 then competence = 6 : pause = 1 : print #ini.pause, "Play" : XxX = 683 : YyY = 3
    print #ini.info, "color blue; set "; XxX; " "; YyY; "; color black"
    if mX > 755 and mX < 775 then
        sizeEDITOR = 1 : pause = 1
        print #ini.info, "size 8; color black; set 765 10; size 6; color red; set 765 10; size 14; color black; set 785 10; size 12; color white; set 785 10; color black"
        print #ini.pause, "Play"
    end if
    if mX > 775 and mX < 795 then
        sizeEDITOR = 2 : pause = 1
        print #ini.info, "size 14; color black; set 785 10; size 12; color red; set 785 10; size 8; color black; set 765 10; size 6; color white; set 765 10; color black"
        print #ini.pause, "Play"
    end if
    if pause = 1 then timer 0 : wait
    goto [boucle]

    [about]
    notice " " + chr$(13) + "Life Simulator created by Alexandre Lomuto" + chr$(13) + chr$(13) + "Use log for a better view on population evolution" + chr$(13) + chr$(13) + "You can stop time with the button 'days'" + chr$(13) + chr$(13) + "You can edit the map with editor, select the size or add population. Water and mountains (gray) cannot be crossed by animals and do not grow plants." + chr$(13) + chr$(13) + "Herbivores eat plants and reproduce either when they have enough food or when they encounter another herbivore. Carnivores feed on herbivores and also reproduce based on their accumulated food or when they encounter another carnivore." + chr$(13) + chr$(13) + "Use Save/Load buttons to save and restore your world!" : wait

    [position]
    mX = MouseX : mY = MouseY
    if competence = 5 then
        UNIT = UNIT + 1 : valU(UNIT) = 1 : CoorX(UNIT) = MouseX : CoorY(UNIT) = MouseY
        LIFE(UNIT) = 1000 : Ngenetic1 = Ngenetic1 + 1 : genetic(UNIT) = GENETICHERBIVORE
        VittesseU(UNIT) = 0
        print #ini.main, "size 2; color 255 255 255; set "; CoorX(UNIT); " "; CoorY(UNIT)
    end if
    if competence = 6 then
        UNIT = UNIT + 1 : valU(UNIT) = UNIT : CoorX(UNIT) = MouseX : CoorY(UNIT) = MouseY
        LIFE(UNIT) = 4000 : Ngenetic2 = Ngenetic2 + 1 : genetic(UNIT) = GENETICCARNIVORE
        VittesseU(UNIT) = 1
        print #ini.main, "size 2; color 0 0 255; set "; CoorX(UNIT); " "; CoorY(UNIT)
    end if
    if pause = 1 then wait
    goto [boucle]

    [terrain]
    if sizeEDITOR = 1 then
        if competence = 1 then print #ini.main, "size 1; color 240 190 150" : valor = 0 : gosub [size1]
        if competence = 2 then print #ini.main, "size 1; color 150 100 230" : valor = WATERCODE : gosub [size1]
        if competence = 3 then print #ini.main, "size 1; color 0 140 0" : valor = PLANTCODE : gosub [size1]
        if competence = 4 then print #ini.main, "size 1; color 100 110 110" : valor = ROCKCODE : gosub [size1]
    else
        if competence = 1 then print #ini.main, "size 1; color 240 190 150" : valor = 0 : gosub [size2]
        if competence = 2 then print #ini.main, "size 1; color 150 100 230" : valor = WATERCODE : gosub [size2]
        if competence = 3 then print #ini.main, "size 1; color 0 140 0" : valor = PLANTCODE : gosub [size2]
        if competence = 4 then print #ini.main, "size 1; color 100 110 110" : valor = ROCKCODE : gosub [size2]
    end if
    if pause = 1 then wait
    #ini.main, "drawsprites"
    goto [boucle]

    [size1]
    print #ini.main, "set "; MouseX; " "; MouseY
    p(MouseX, MouseY) = valor
    return

    [size2]
    for dxx = -1 to 1
        for dyy = -1 to 1
            print #ini.main, "set "; (MouseX + dxx); " "; (MouseY + dyy)
            p(MouseX + dxx, MouseY + dyy) = valor
        next dyy
    next dxx
    return

    [log]
    if logACTIVATION = 1 then goto [boucle]
    WindowWidth = 807 : WindowHeight = 630
    UpperLeftX = UpperLeftX2 + WindowWidth + 20 : UpperLeftY = int((DisplayHeight - WindowHeight) / 2)
    open "Log Pop/Time" for graphics_nsb_nf as #wg
    logACTIVATION = 1
   [refreshLOG]
    IncrY = 0 : logVALpop = 1500
    #wg "trapclose [quitLOG]; down; fill 240 190 150; size 1"

    ' Dessiner les axes et graduations
    #wg "color darkgray"
    ' Axe vertical (population)
    #wg "line 70 20 70 570"
    ' Axe horizontal (temps)
    #wg "line 70 570 730 570"

    ' Graduations verticales (population) avec lignes de grille
    for gradY = 0 to 10
        yPos = 570 - (gradY * 55)
        popValue = gradY * 150
        ' Ligne de grille horizontale
        #wg "color 200 180 160"
        #wg "line 70 "; yPos; " 730 "; yPos
        ' Graduation sur l'axe
        #wg "color darkgray"
        #wg "line 65 "; yPos; " 70 "; yPos
        #wg "color black; backcolor 240 190 150; font Cascadia_Code 6"
        yText = yPos - 3
        #wg "place 35 "; yText; " ;\";popValue
    next gradY

    ' Graduations horizontales (temps) avec lignes de grille
    #wg "color darkgray"
    for gradX = 0 to 6
        xPos = 70 + (gradX * 110)
        timeValue = gradX * 22500
        ' Ligne de grille verticale
        #wg "color 200 180 160"
        #wg "line "; xPos; " 20 "; xPos; " 570"
        ' Graduation sur l'axe
        #wg "color darkgray"
        #wg "line "; xPos; " 570 "; xPos; " 575"
        #wg "color black; backcolor 240 190 150; font Cascadia_Code 6"
        xText = xPos - 15
        #wg "place "; xText; " 585 ;\";timeValue
    next gradX

    ' Redessiner les axes principaux par-dessus les grilles
    #wg "color darkgray"
    #wg "line 70 20 70 570"
    #wg "line 70 570 730 570"

    ' Lgende
    print #wg, "color blue; font Cascadia_Code 8 bold; backcolor 240 190 150"
    print #wg, "place 707 20 ;\"; "Carnivors pop"
    print #wg, "color yellow; font Cascadia_Code 8 bold; backcolor 240 190 150"
    print #wg, "place 707 50 ;\"; "Time line"
    print #wg, "color white; font Cascadia_Code 8 bold; backcolor 240 190 150"
    print #wg, "place 707 35 ;\"; "Herbivors pop"
    print #wg, "color black; font Cascadia_Code 7; backcolor 240 190 150"
    goto [boucle]

    [quitLOG]
    close #wg : logACTIVATION = 0
    goto [boucle]

    [pause]
    if pause = 0 then pause = 1 : print #ini.pause, "Play" : timer 0 : wait
    if pause = 1 then pause = 0 : print #ini.pause, "Days" : goto [boucle]

    [quit]
    close #ini
    if logACTIVATION = 1 then close #wg
    end

    ' ========== GNRATEUR MONDE ==========
    [GenerateWorld]
    print #ini.main, "size 1"
    print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "place 300 13; color black; backcolor white ;\"; "Generation of the world... 0%"
    dim heightMap(800, 580) : dim lobeX(10), lobeY(10)
    numContinents = int(rnd(1) * 2 + 2)
    for cont = 1 to numContinents
        scan : progressPct = int((cont / numContinents) * 25)
        print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
        print #ini.info, "place 300 13; color black; backcolor white ;\"; "Generation of continents... "; progressPct; "%"
        centerX = int(rnd(1) * 800) : centerY = int(rnd(1) * 580)
        radiusX = int(rnd(1) * 200 + 150) : radiusY = int(rnd(1) * 150 + 150)
        invRadiusX = 1 / radiusX : invRadiusY = 1 / radiusY : invRadiusXHalf = 2 / radiusX
        numLobes = int(rnd(1) * 4 + 3)
        for lobe = 1 to numLobes
            angle = (lobe / numLobes) * 6.28 + rnd(1) * 1 : distance = rnd(1) * radiusX * 0.6
            lobeX(lobe) = centerX + cos(angle) * distance : lobeY(lobe) = centerY + sin(angle) * distance
        next lobe
        scanCounter = 0
        for yy = 0 to 580 step 2
            scanCounter = scanCounter + 1
            if scanCounter mod 8 = 0 then
                scan : progressPct = int((cont - 1) / numContinents * 25 + (yy / 580) * (25 / numContinents))
                if progressPct > 25 then progressPct = 25
                print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
                print #ini.info, "place 300 13; color black; backcolor white ;\"; "Generation of continents... "; progressPct; "%"
            end if
            for xx = 0 to 800 step 2
                deltaX = xx - centerX : deltaY = yy - centerY
                if deltaX > 400 then deltaX = deltaX - 800
                if deltaX < -400 then deltaX = deltaX + 800
                if deltaY > 290 then deltaY = deltaY - 580
                if deltaY < -290 then deltaY = deltaY + 580
                distX = deltaX * invRadiusX : distY = deltaY * invRadiusY
                distCenter = sqr(distX * distX + distY * distY)
                if distCenter > 1.5 then goto [skipT]
                minLobeDist = 999999
                for lobe = 1 to numLobes
                    deltaXLobe = xx - lobeX(lobe) : deltaYLobe = yy - lobeY(lobe)
                    if deltaXLobe > 400 then deltaXLobe = deltaXLobe - 800
                    if deltaXLobe < -400 then deltaXLobe = deltaXLobe + 800
                    if deltaYLobe > 290 then deltaYLobe = deltaYLobe - 580
                    if deltaYLobe < -290 then deltaYLobe = deltaYLobe + 580
                    lobeDist = deltaXLobe * deltaXLobe + deltaYLobe * deltaYLobe
                    if lobeDist < minLobeDist then minLobeDist = lobeDist
                next lobe
                minLobeDist = sqr(minLobeDist)
                noise1 = sin(xx * 0.1) * cos(yy * 0.1) * 0.15
                noise2 = sin(xx * 0.03) * cos(yy * 0.03) * 0.25
                noise3 = (rnd(1) - 0.5) * 0.3
                totalNoise = noise1 + noise2 + noise3
                lobeInfluence = 1 - minLobeDist * invRadiusXHalf
                centerInfluence = 1 - distCenter
                combinedInfluence = centerInfluence + lobeInfluence * 0.8 + totalNoise
                if combinedInfluence > 0 then
                    baseHeight = combinedInfluence * 20
                    if baseHeight > 0 then
                        hillNoise = (sin(xx * 0.05) + cos(yy * 0.05)) * 4
                        hillNoise = hillNoise + (sin(xx * 0.02) + cos(yy * 0.02)) * 6 + rnd(1) * 5
                        totalHeight = baseHeight + hillNoise
                        actualX = xx : actualY = yy
                        if actualX > 800 then actualX = actualX - 800
                        if actualY > 580 then actualY = actualY - 580
                        if totalHeight > 0 and heightMap(actualX, actualY) < totalHeight then
                            heightMap(actualX, actualY) = totalHeight
                            if actualX < 800 then heightMap(actualX + 1, actualY) = totalHeight
                            if actualY < 580 then heightMap(actualX, actualY + 1) = totalHeight
                            if actualX < 800 and actualY < 580 then heightMap(actualX + 1, actualY + 1) = totalHeight
                        end if
                    end if
                end if
                [skipT]
            next xx
        next yy
    next cont
    print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "place 300 13; color black; backcolor white ;\"; "Land generation... 25%"
    for yy = 0 to 580
        if heightMap(0, yy) = 0 then heightMap(0, yy) = -5
        if heightMap(800, yy) = 0 then heightMap(800, yy) = -5
    next yy
    for xx = 0 to 800
        if heightMap(xx, 0) = 0 then heightMap(xx, 0) = -5
        if heightMap(xx, 580) = 0 then heightMap(xx, 580) = -5
    next xx
    totalPixels = 581 : currentLine = 0
    cmdWaterColor$ = "color 150 100 230; set "
    for yy = 0 to 580 step 1
        scan : currentLine = currentLine + 1
        if currentLine mod 10 = 0 then
            progressPct = 25 + int((currentLine / totalPixels) * 75)
            print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
            print #ini.info, "place 300 13; color black; backcolor white ;\"; "Land rendering... "; progressPct; "%"
        end if
        for xx = 0 to 800 step 1
            height = heightMap(xx, yy)
            if height <= 0 then
                p(xx, yy) = WATERCODE
                print #ini.main, cmdWaterColor$; xx; " "; yy
            else
                if height > 70 then
                    p(xx, yy) = ROCKCODE
                    grayShade = int(90 + rnd(1) * 30)
                    print #ini.main, "color "; grayShade; " "; grayShade + 10; " "; grayShade + 10; "; set "; xx; " "; yy
                else
                    if height > 3 then
                        p(xx, yy) = 0
                    else
                        p(xx, yy) = WATERCODE
                        print #ini.main, cmdWaterColor$; xx; " "; yy
                    end if
                end if
            end if
        next xx
    next yy
    print #ini.info, "place 300 13; color white; backcolor white ;\"; "                                        "
    print #ini.info, "place 300 13; color black; backcolor white ;\"; "Complete world generation ! 100%"
    scan
    return
